Пакет с примерами кода на PHP

> Поддерживаемые версии:  
> PHP 8.4.1  
> Composer 2.8.3  

## Установка зависимостей

Установите зависимости с помощью `composer` выполнив команду в текущей директории:
```bash
composer install 
```

# Отправка запросов в API

## Получение приватного ключа

Приватный ключ генерировать не нужно. Его можно получить в вашей дашборде, при настройке кассы после её создания.  
После того, как вы получите приватный ключ, сохраните его в файл `private_key_for_api.pem` и положите его в текущую директорию.

## Запуск примеров кода

В качестве примеров реализованы скрипты:  
- на получение доступного списка банков `banks_get.php`
- создание заявки на оплату `payment_create.php`
- получение информации по статусу созданной заявки на оплату `payment_get_info.php`
- создание заявки на выплату `payout_create.php`
- получение информации по статусу созданной заявки на выплату `payout_get_info.php`

Перед тем как запустить примеры, вам необходимо заполнить конфигурационный файл `config.php`:

1. `project_id` - id ващей кассы, который можно найти на дашборде: _Вкладка "Кассы" -> Колонка "ID"_
2. `callback_url` - домен вашего магазина для получения колбэков. 


# Обработка колбэков

При обработке колбэков необходимо валидировать цифровую подпись, которую наш сервис отправляет с каждым колбэком.

## Получение публичного ключа

Публичный ключ, для валидации цифровой подписи, можно получить в настройках кассы: _"API" -> "Настройки Callback"._    
В открывшейся модальном окне найдите блок "Public Key" и нажмите на значок скачивания. 
Переименуйте скаченный файл на `public_key_for_callbacks.pem` и положите его в текущую директорию.

## Запуск примера кода

В качестве примера кода реализован скрипт `callback_processor.php`, в котором запускается веб-сервис. 
В веб-сервисе реализона ручка `/callback/{status}` для получения колбэков. 
В этой ручке реализована логика проверки цифр. подписи, которую вы можете проверить запустив 
этот скрипт.  

Запустить скрипт можно командой:
```bash
php -S localhost:8000 callback_processor.php
```

Заметьте, если цифровая подпись корректная, то в _stdout_ будет выведен лог "Signature is valid (via OpenSSL)"

