import { projectId, privateKeyFilePath, baseUrl, callbackUrl } from './config.js';
import { makeRequest } from './helper.js';

const url = `${baseUrl}/api/v1/payment/p2p/payout`;

const payloadSpb = {
    general: {
        project_id: projectId,
        payment_id: "Test-js-sbp",
        merchant_callback_url: `${callbackUrl}/callback/info`,
        merchant_success_callback_url: `${callbackUrl}/callback/success`,
        merchant_decline_callback_url: `${callbackUrl}/callback/decline`,
    },
    payment: {
        method: "sbp-p2p",
        amount: 111100, // В минорных единицах 111100 = 1111.00 рублей
        currency: "RUB",
    },
    receiver: {
        phone: "+79295281111",
        bank_code: "100000000111",
    },
    customer: {
        id: "test",
        ip_address: "192.168.0.1",
        country: "RU",
    }
};

const payloadCard = {
    general: {
        project_id: projectId,
        payment_id: "Test-js-card",
        merchant_callback_url: `${callbackUrl}/callback/info`,
        merchant_success_callback_url: `${callbackUrl}/callback/success`,
        merchant_decline_callback_url: `${callbackUrl}/callback/decline`,
    },
    payment: {
        method: "card-p2p",
        amount: 111100, // В минорных единицах 111100 = 1111.00 рублей
        currency: "RUB",
    },
    receiver: {
        pan: "5469111111111111",
    },
    customer: {
        id: "test",
        ip_address: "192.168.0.1",
        country: "RU",
    }
};
const response = makeRequest(
    projectId,
    privateKeyFilePath,
    url,
    payloadSpb
);

console.log(response);
